/* Copyright (c) 2012-2017, ARM Limited and Contributors
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge,
 * to any person obtaining a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

precision mediump float;

uniform sampler2D u_texture;
uniform sampler2D u_MaskTexture;
uniform vec2 u_resolution;

varying vec2 v_v2UV;

void main()
{
    vec4 mask = texture2D(u_MaskTexture, v_v2UV);

    vec4 result;
    if (mask.a > 0.0) { // Inpainted Area
        //result = texture2D(u_texture, v_v2UV);

        // Apply Blur
        float stepH = 1.0 / u_resolution.x;
        float stepV = 1.0 / u_resolution.y;
        vec4 sum = vec4(0.0);

        sum += texture2D(u_texture, vec2(v_v2UV.x - 2.0 * stepH, v_v2UV.y - 2.0 * stepV)) * 0.003765;
        sum += texture2D(u_texture, vec2(v_v2UV.x - 1.0 * stepH, v_v2UV.y - 2.0 * stepV)) * 0.015019;
        sum += texture2D(u_texture, vec2(v_v2UV.x - 0.0 * stepH, v_v2UV.y - 2.0 * stepV)) * 0.023792;
        sum += texture2D(u_texture, vec2(v_v2UV.x + 1.0 * stepH, v_v2UV.y - 2.0 * stepV)) * 0.015019;
        sum += texture2D(u_texture, vec2(v_v2UV.x + 2.0 * stepH, v_v2UV.y - 2.0 * stepV)) * 0.003765;
        sum += texture2D(u_texture, vec2(v_v2UV.x - 2.0 * stepH, v_v2UV.y - 1.0 * stepV)) * 0.015019;
        sum += texture2D(u_texture, vec2(v_v2UV.x - 1.0 * stepH, v_v2UV.y - 1.0 * stepV)) * 0.059912;
        sum += texture2D(u_texture, vec2(v_v2UV.x - 0.0 * stepH, v_v2UV.y - 1.0 * stepV)) * 0.094907;
        sum += texture2D(u_texture, vec2(v_v2UV.x + 1.0 * stepH, v_v2UV.y - 1.0 * stepV)) * 0.059912;
        sum += texture2D(u_texture, vec2(v_v2UV.x + 2.0 * stepH, v_v2UV.y - 1.0 * stepV)) * 0.015019;
        sum += texture2D(u_texture, vec2(v_v2UV.x - 2.0 * stepH, v_v2UV.y - 0.0 * stepV)) * 0.023792;
        sum += texture2D(u_texture, vec2(v_v2UV.x - 1.0 * stepH, v_v2UV.y - 0.0 * stepV)) * 0.094907;
        sum += texture2D(u_texture, vec2(v_v2UV.x - 0.0 * stepH, v_v2UV.y - 0.0 * stepV)) * 0.150342;
        sum += texture2D(u_texture, vec2(v_v2UV.x + 1.0 * stepH, v_v2UV.y - 0.0 * stepV)) * 0.094907;
        sum += texture2D(u_texture, vec2(v_v2UV.x + 2.0 * stepH, v_v2UV.y - 0.0 * stepV)) * 0.023792;
        sum += texture2D(u_texture, vec2(v_v2UV.x - 2.0 * stepH, v_v2UV.y + 1.0 * stepV)) * 0.015019;
        sum += texture2D(u_texture, vec2(v_v2UV.x - 1.0 * stepH, v_v2UV.y + 1.0 * stepV)) * 0.059912;
        sum += texture2D(u_texture, vec2(v_v2UV.x - 0.0 * stepH, v_v2UV.y + 1.0 * stepV)) * 0.094907;
        sum += texture2D(u_texture, vec2(v_v2UV.x + 1.0 * stepH, v_v2UV.y + 1.0 * stepV)) * 0.059912;
        sum += texture2D(u_texture, vec2(v_v2UV.x + 2.0 * stepH, v_v2UV.y + 1.0 * stepV)) * 0.015019;
        sum += texture2D(u_texture, vec2(v_v2UV.x - 2.0 * stepH, v_v2UV.y + 2.0 * stepV)) * 0.003765;
        sum += texture2D(u_texture, vec2(v_v2UV.x - 1.0 * stepH, v_v2UV.y + 2.0 * stepV)) * 0.015019;
        sum += texture2D(u_texture, vec2(v_v2UV.x - 0.0 * stepH, v_v2UV.y + 2.0 * stepV)) * 0.023792;
        sum += texture2D(u_texture, vec2(v_v2UV.x + 1.0 * stepH, v_v2UV.y + 2.0 * stepV)) * 0.015019;
        sum += texture2D(u_texture, vec2(v_v2UV.x + 2.0 * stepH, v_v2UV.y + 2.0 * stepV)) * 0.003765;
        result = sum;
    } else {
        result = texture2D(u_texture, v_v2UV);
    }

    gl_FragColor = vec4(result.xyz, 1.0);
}
